/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item;

import dev.toma.gunsrpg.ModTabs;
import dev.toma.gunsrpg.common.container.GenericStorageContainer;
import dev.toma.gunsrpg.common.item.BaseItem;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.locate.ammo.ItemLocator;
import dev.toma.gunsrpg.util.math.IDimensions;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class StorageItem
extends BaseItem
implements ItemLocator.SaveInventoryProvider<IInventory> {
    private final IDimensions dimensions;
    private final IInputFilter inputFilter;
    private final IContainerProvider containerProvider;

    public StorageItem(String name, Item.Properties properties, int width, int height, IInputFilter filter, IContainerProvider containerProvider) {
        super(name, properties.func_200917_a(1).func_200916_a(ModTabs.ITEM_TAB));
        this.dimensions = IDimensions.of(width, height);
        this.inputFilter = filter;
        this.containerProvider = containerProvider;
    }

    @Override
    public ItemLocator.InventoryHolder<IInventory> getInventoryHolder(ItemStack stack) {
        InventorySaveCallback callback = inv -> StorageItem.saveInventoryContents(stack, inv);
        IInventory inventory = this.getInventory(stack, callback);
        return ItemLocator.InventoryProvider.vanilla(inventory, stack);
    }

    @Override
    public void insertEditedItem(IInventory inventory, int slot, ItemStack stack) {
        inventory.func_70299_a(slot, stack.func_77946_l());
    }

    @Override
    public void saveInventory(IInventory inventory, ItemStack heldItem) {
        StorageItem.saveInventoryContents(heldItem, inventory);
    }

    public IInventory getInventory(ItemStack stack, InventorySaveCallback callback) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        ListNBT list = nbt.func_150297_b("Items", 9) ? nbt.func_150295_c("Items", 10) : new ListNBT();
        return StorageItem.createInventoryFromData(list, this.dimensions.getArea(), callback);
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!level.field_72995_K) {
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new CompoundNBT());
            }
            ITextComponent title = this.getContainerName();
            SimpleNamedContainerProvider provider = new SimpleNamedContainerProvider((id, inv, own) -> this.containerProvider.createContainerInstance(inv, id), title);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider);
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public IDimensions getDimensions() {
        return this.dimensions;
    }

    public IInputFilter getInputFilter() {
        return this.inputFilter;
    }

    protected ITextComponent getContainerName() {
        return new TranslationTextComponent("screen." + ModUtils.convertToLocalization(this.getRegistryName()));
    }

    public static IInventory createInventoryFromData(ListNBT items, int requiredSize, InventorySaveCallback callback) {
        GenericStorageContainer.SavingInventory inventory = new GenericStorageContainer.SavingInventory(requiredSize, callback);
        for (int i = 0; i < items.size(); ++i) {
            CompoundNBT data = items.func_150305_b(i);
            int slotId = data.func_74762_e("slotId");
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)data.func_74775_l("item"));
            inventory.func_70299_a(slotId, stack);
        }
        return inventory;
    }

    public static void saveInventoryContents(ItemStack stack, IInventory inventory) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            CompoundNBT data = new CompoundNBT();
            data.func_74768_a("slotId", i);
            data.func_218657_a("item", (INBT)itemStack.serializeNBT());
            list.add((Object)data);
        }
        stack.func_196082_o().func_218657_a("Items", (INBT)list);
    }

    @FunctionalInterface
    public static interface InventorySaveCallback {
        public void onSave(IInventory var1);
    }

    @FunctionalInterface
    public static interface IInputFilter {
        public boolean isValidInput(ItemStack var1);
    }

    @FunctionalInterface
    public static interface IContainerProvider {
        public GenericStorageContainer createContainerInstance(PlayerInventory var1, int var2);
    }
}

